#include<cstdio>
#include<cstring>
#include<algorithm>
#include<iostream>
#include<cmath>
#include<set>
#include<vector>
#include<random>
using namespace std;
const int N = 4336;
const int dim = 2;
const double eta = 0.018;
double dis[N + 1];
double cost = 0;
vector<int> Fset;
vector<double> errlist;
struct demand {
	double x[dim + 1];
	double c, r;
	int t;
}D[N + 1], P[N + 1], Tmp[N + 1], Pred[N + 1];
default_random_engine e;
uniform_real_distribution<double> u(-eta, eta); // generate error 
int order[N + 5];
bool train[N + 5];

inline double dist(demand &d1, demand &d2) {
	double ret = 0;
	for (int i = 1; i <= dim; i++)
		ret += (d1.x[i] - d2.x[i]) * (d1.x[i] - d2.x[i]);
	return sqrt(ret);
}

bool cmp(demand a, demand b) {
	return a.r < b.r;
}


void pretrain(int M) {
	for (int i = 1; i <= M; i++) {
		Tmp[i] = D[order[i]];
		train[order[i]] = 1;
	}
	Fset.clear();
	for (int i = 1; i <= M; i++) {
		for (int j = 1; j <= M; j++)
			dis[j] = dist(Tmp[i], Tmp[j]);
		sort(dis + 1, dis + M + 1); 
		double total = 0;
		double r = 0;
		for (int j = 1; j <= M; j++) {
			total += dis[j];
			r = (total + Tmp[i].c) / j;
			if ((r <= dis[j + 1]  && r >= dis[j]) || j == M) {
				Tmp[i].r = r;   
				break;
			}
		}
	}
	sort(Tmp + 1, Tmp + M + 1, cmp);
	for (int i = 1; i <= M; i++) {
		int siz = Fset.size();
		bool flag = 0;
		for (int j = 0; j < siz; j++) {
			int pos = Fset[j];
			if (dist(Tmp[pos], Tmp[i]) <= 2 * Tmp[i].r) {
				flag = 1;
				break;
			}
		}
		if (!flag) {
			Fset.push_back(i);
			cost += Tmp[i].c;
		}
	}
}

void MP(int M) {
	for (int i = 1; i <= 900; i++)
		Tmp[i] = D[order[i]];
	int cnt = 900;
	for (int i = 1; i <= M; i++) 
		if (!train[i]) 
			Tmp[++cnt] = D[i];
	Fset.clear();
	M = cnt;
	for (int i = 1; i <= M; i++) {
		for (int j = 1; j <= M; j++)
			dis[j] = dist(Tmp[i], Tmp[j]);
		sort(dis + 1, dis + M + 1); 
		double total = 0;
		double r = 0;
		for (int j = 1; j <= M; j++) {
			total += dis[j];
			r = (total + Tmp[i].c) / j;
			if ((r <= dis[j + 1]  && r >= dis[j]) || j == M) {
				Tmp[i].r = r;   
				break;
			}
		}
	}
	sort(Tmp + 1, Tmp + M + 1, cmp);
	for (int i = 1; i <= M; i++) {
		int siz = Fset.size();
		bool flag = 0;
		for (int j = 0; j < siz; j++) {
			int pos = Fset[j];
			if (dist(Tmp[pos], Tmp[i]) <= 2 * Tmp[i].r) {
				flag = 1;
				break;
			}
		}
		if (!flag) {
			Fset.push_back(i);
			cost += Tmp[i].c;
		}
	}
}


int main() {
	freopen("nonuniform.txt", "r", stdin);
	for (int i = 1; i <= N; i++) {
		for (int j = 1; j <= dim; j++)
			scanf("%lf", &D[i].x[j]);
		scanf("%lf", &D[i].c);
		D[i].t = i;
	}
	
	for (int i = 1; i <= N; i++)
		order[i] = i;
	random_shuffle(order + 1, order + N + 1);
	pretrain(900);

	for (int i = 1; i <= N; i++) {
		if (i % 1000 == 0) {
			MP(i);
		}
		if (Fset.size() == 0) {
			Pred[i] = D[i];
		}
		else {
			int siz = Fset.size();
			int optpos = Fset[0];
			for (int j = 1; j < siz; j++) {
				int pos = Fset[j];
				if (dist(Tmp[optpos], D[i]) > dist(Tmp[pos], D[i])) 
					optpos = pos;
			}
			Pred[i] = Tmp[optpos];
		}
	}

	freopen("real_predict.txt", "w", stdout);
	for (int i = 1; i <= N; i++) {
		printf("%d %.6lf\n", Pred[i].t, Pred[i].c);
		for (int j = 1; j <= dim; j++)
			printf("%.6lf ", Pred[i].x[j]);
		puts("");
	}
}